package nemosofts.voxradio.activity;

import android.annotation.SuppressLint;
import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.os.AsyncTask;
import android.os.PowerManager;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.telephony.TelephonyManager;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;

import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.ext.mediasession.TimelineQueueNavigator;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.ui.PlayerNotificationManager;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.net.ssl.HttpsURLConnection;

import nemosofts.voxradio.R;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AudioRecorder;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.MessageEvent;
import nemosofts.voxradio.utils.ParserM3UToURL;
import nemosofts.voxradio.utils.helper.DBHelper;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.receiver.MediaButtonIntentReceiver;

public class PlayerService extends IntentService implements Player.Listener {

    public static final String ACTION_TOGGLE = "action.ACTION_TOGGLE";
    public static final String ACTION_PLAY = "action.ACTION_PLAY";
    public static final String ACTION_NEXT = "action.ACTION_NEXT";
    public static final String ACTION_PREVIOUS = "action.ACTION_PREVIOUS";
    public static final String ACTION_STOP = "action.ACTION_STOP";
    public static final String ACTION_SEEKTO = "action.ACTION_SEEKTO";

    public static ExoPlayer exoPlayer = null;
    MediaSessionCompat mMediaSession;

    DefaultBandwidthMeter.Builder bandwidthMeter;
    public static DataSource.Factory dataSourceFactory;

    static PlayerService playerService;
    Helper helper;
    DBHelper dbHelper;
    Boolean isNewSong = false;
    Bitmap bitmap;
    ComponentName componentName;
    AudioManager mAudioManager;
    PowerManager.WakeLock mWakeLock;

    PlayerNotificationManager notificationManager;
    MediaSessionConnector mediaSessionConnector;
    NotificationReceiver notificationReceiver;
    PlayerNotificationManager.BitmapCallback callbackBitmap;

    public PlayerService() {
        super(null);
    }

    public static PlayerService getInstance() {
        if (playerService == null) {
            playerService = new PlayerService();
        }
        return playerService;
    }

    @NonNull
    public static Boolean getIsPlayling() {
        return exoPlayer != null && exoPlayer.getPlayWhenReady();
    }

    public long getDuration() {
        if (exoPlayer == null) {
            return 0;
        } else {
            return exoPlayer.getDuration();
        }
    }

    public int getAudioSessionID() {
        if (exoPlayer == null) {
            return 0;
        } else {
            return exoPlayer.getAudioSessionId();
        }
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
    }

    @SuppressLint("UnspecifiedRegisterReceiverFlag")
    @Override
    public void onCreate() {

        helper = new Helper(getApplicationContext());
        dbHelper = new DBHelper(getApplicationContext());

        mAudioManager = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
        mAudioManager.requestAudioFocus(onAudioFocusChangeListener, AudioManager.STREAM_MUSIC,
                AudioManager.AUDIOFOCUS_GAIN);

        componentName = new ComponentName(getPackageName(), MediaButtonIntentReceiver.class.getName());
        mAudioManager.registerMediaButtonEventReceiver(componentName);

        try {
            registerReceiver(onCallIncome, new IntentFilter("android.intent.action.PHONE_STATE"));
            registerReceiver(onHeadPhoneDetect, new IntentFilter(AudioManager.ACTION_AUDIO_BECOMING_NOISY));
        } catch (Exception e) {
            e.printStackTrace();
        }

        bandwidthMeter = new DefaultBandwidthMeter.Builder(this);

        exoPlayer = new ExoPlayer.Builder(getApplicationContext()).build();
        exoPlayer.addListener(this);

        PowerManager powerManager = (PowerManager) getSystemService(Context.POWER_SERVICE);
        mWakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, getClass().getName());
        mWakeLock.setReferenceCounted(false);

        AudioAttributes audioAttributes = new AudioAttributes.Builder()
                .setUsage(C.USAGE_MEDIA)
                .setContentType(C.AUDIO_CONTENT_TYPE_MUSIC)
                .build();
        exoPlayer.setAudioAttributes(audioAttributes, true);
        mMediaSession = new MediaSessionCompat(this, getResources().getString(R.string.app_name));
        mMediaSession.setActive(true);
        mediaSessionConnector = new MediaSessionConnector(mMediaSession);

        mediaSessionConnector.setPlayer(exoPlayer);

        TimelineQueueNavigator queueNavigator =
                new TimelineQueueNavigator(mMediaSession) {
                    @NonNull
                    @Override
                    public MediaDescriptionCompat getMediaDescription(@NonNull Player player, int windowIndex) {
                        return new MediaDescriptionCompat.Builder()
                                .setTitle(Callback.arrayList_play.get(windowIndex).getRadioTitle())
                                .setDescription("MediaDescription description for " + windowIndex)
                                .setSubtitle(Callback.arrayList_play.get(windowIndex).getCategoryName())
                                .build();
                    }
                };
        mediaSessionConnector.setQueueNavigator(queueNavigator);

        List<MediaSessionCompat.QueueItem> queue = new ArrayList<>();
        for (int i = 0; i < Callback.arrayList_play.size(); i++) {
            queue.add(new MediaSessionCompat.QueueItem(queueNavigator.getMediaDescription(exoPlayer, i), i));
        }
        mMediaSession.setQueue(queue);

        notificationReceiver = new NotificationReceiver();
        registerReceiver(notificationReceiver, addIntentFilter());

        super.onCreate();
    }

    @Override
    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        try {
            String action = Objects.requireNonNull(intent).getAction();
            switch (Objects.requireNonNull(action)) {
                case ACTION_PLAY:
                    startNewSong();
                    break;
                case ACTION_TOGGLE:
                    togglePlay();
                    break;
                case ACTION_SEEKTO:
                    seekTo(intent.getExtras().getLong("seekto"));
                    break;
                case ACTION_STOP:
                    stop(intent);
                    break;
                case ACTION_PREVIOUS:
                    if (helper.isNetworkAvailable()) {
                        previous();
                        exoPlayer.seekToDefaultPosition(Callback.playPos);
                    } else {
                        Toast.makeText(getApplicationContext(), getResources().getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                    }
                    break;
                case ACTION_NEXT:
                    if (helper.isNetworkAvailable()) {
                        next();
                        exoPlayer.seekToDefaultPosition(Callback.playPos);
                    } else {
                        Toast.makeText(getApplicationContext(), getResources().getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                    }
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return START_STICKY;
    }

    private void createNoti() {
        String channelId = getResources().getString(R.string.app_name);
        int notificationId = 111111;
        notificationManager = new PlayerNotificationManager.Builder(this, notificationId, channelId)
            .setNotificationListener(notificationListener)
            .setMediaDescriptionAdapter(descriptionAdapter)
            .setChannelImportance(NotificationManager.IMPORTANCE_HIGH)
            .setSmallIconResourceId(R.drawable.ic_notification)
            .setChannelDescriptionResourceId(R.string.app_name)
            .setNextActionIconResourceId(R.drawable.ic_skip_next)
            .setPreviousActionIconResourceId(R.drawable.ic_skip_previous)
            .setPlayActionIconResourceId(R.drawable.ic_play)
            .setPauseActionIconResourceId(R.drawable.ic_pause)
            .setChannelNameResourceId(R.string.app_name)
            .build();

        notificationManager.setPlayer(exoPlayer);
        notificationManager.setPriority(NotificationCompat.PRIORITY_MAX);

        notificationManager.setUsePlayPauseActions(true);
        notificationManager.setUseFastForwardAction(false);
        notificationManager.setUseRewindAction(false);
        notificationManager.setUseNextAction(true);
        notificationManager.setUsePreviousAction(true);
        notificationManager.setUseStopAction(true);
        notificationManager.setUseNextActionInCompactView(true);
        notificationManager.setUsePreviousActionInCompactView(true);
        notificationManager.setMediaSessionToken(mMediaSession.getSessionToken());

        updateNotiImage();
    }

    PlayerNotificationManager.NotificationListener notificationListener = new PlayerNotificationManager.NotificationListener() {
        @Override
        public void onNotificationCancelled(int notificationId, boolean dismissedByUser) {
        }

        @Override
        public void onNotificationPosted(int notificationId, Notification notification, boolean ongoing) {
            if (ongoing) {
                startForeground(notificationId, notification);
            }
        }
    };

    PlayerNotificationManager.MediaDescriptionAdapter descriptionAdapter = new PlayerNotificationManager.MediaDescriptionAdapter() {
        @Override
        public CharSequence getCurrentContentTitle(Player player) {
            if (player != null){
                int playPos = player.getCurrentWindowIndex();
                if (playPos != Callback.playPos){
                    changePlayerPlayPos(playPos);
                }
            }
            return Callback.arrayList_play.get(Callback.playPos).getRadioTitle();
        }

        @Nullable
        @Override
        public PendingIntent createCurrentContentIntent(Player player) {
            Intent notificationIntent = new Intent(PlayerService.this, SplashActivity.class);
            notificationIntent.setAction(Intent.ACTION_MAIN);
            notificationIntent.addCategory(Intent.CATEGORY_LAUNCHER);
            notificationIntent.putExtra("isnoti", true);
            return PendingIntent.getActivity(PlayerService.this, 0, notificationIntent, PendingIntent.FLAG_IMMUTABLE);
        }

        @Nullable
        @Override
        public CharSequence getCurrentContentText(Player player) {
            return Callback.arrayList_play.get(Callback.playPos).getCategoryName();
        }

        @Nullable
        @Override
        public Bitmap getCurrentLargeIcon(Player player, PlayerNotificationManager.BitmapCallback callback) {
            callbackBitmap = callback;
            return bitmap;
        }
    };

    @Override
    public void onPlaybackStateChanged(int playbackState) {
        Player.Listener.super.onPlaybackStateChanged(playbackState);
        if (playbackState == Player.STATE_READY) {
            exoPlayer.play();
            if (Boolean.TRUE.equals(isNewSong)) {
                isNewSong = false;
                Callback.isPlayed = true;
                setBuffer(false);
                GlobalBus.getBus().postSticky(Callback.arrayList_play.get(Callback.playPos));
                if (notificationManager == null) {
                    createNoti();
                } else {
                    updateNotiImage();
                }
            }
        } else if (playbackState == Player.STATE_ENDED) {
            onCompletion();
        }
    }

    @Override
    public void onIsPlayingChanged(boolean isPlaying) {
        Player.Listener.super.onIsPlayingChanged(isPlaying);
        changePlayPause(isPlaying);
        if (isPlaying) {
            if (!mWakeLock.isHeld()) {
                mWakeLock.acquire(60000);
            }
        } else {
            if (mWakeLock.isHeld()) {
                mWakeLock.release();
            }
        }
    }

    @Override
    public void onPlayerError(@NonNull PlaybackException error) {
        Player.Listener.super.onPlayerError(error);
        Toast.makeText(getApplicationContext(), "Failed : " + error.getErrorCodeName(), Toast.LENGTH_SHORT).show();
        exoPlayer.setPlayWhenReady(false);
        setBuffer(false);
        changePlayPause(false);
    }

    @Override
    public void onMediaMetadataChanged(@NonNull MediaMetadata mediaMetadata) {
        Player.Listener.super.onMediaMetadataChanged(mediaMetadata);
    }

    private void startNewSong() {
        isNewSong = true;
        setBuffer(true);
        isRecord();
        try {

            dataSourceFactory = new DefaultDataSourceFactory(getApplicationContext(),Util.getUserAgent(getApplicationContext(), "tamilaudiopro"));

            if (Boolean.TRUE.equals(Callback.isNewAdded || exoPlayer.getMediaItemCount() == 0) || Callback.playPos >= exoPlayer.getMediaItemCount()) {
                loadMultipleMedia();
            }

            exoPlayer.seekToDefaultPosition(Callback.playPos);
            exoPlayer.prepare();
            exoPlayer.setPlayWhenReady(true);

            try {
                if (Boolean.TRUE.equals(Callback.isRadio)) {
                    dbHelper.addToRecent(Callback.arrayList_play.get(Callback.playPos));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMultipleMedia() {
        List<MediaSource> mediaItemsSource = new ArrayList<>();
        for (ItemRadio playerItem : Callback.arrayList_play) {
            MediaSource sampleSource;
            String url = playerItem.getRadioUrl();
            if (url.contains(".m3u8")) {
                sampleSource = new HlsMediaSource.Factory(dataSourceFactory)
                        .createMediaSource(new MediaItem.Builder().setUri(url).build());
            } else if (url.contains(".m3u") || url.contains("yp.shoutcast.com/sbin/tunein-station.m3u?id=")) {
                url = ParserM3UToURL.parse(url, "m3u");
                sampleSource = new ProgressiveMediaSource.Factory(dataSourceFactory)
                        .createMediaSource(new MediaItem.Builder().setUri(url).build());
            } else if (url.contains(".pls") || url.contains("listen.pls?sid=") || url.contains("yp.shoutcast.com/sbin/tunein-station.pls?id=")) {
                url = ParserM3UToURL.parse(url, "pls");
                sampleSource = new ProgressiveMediaSource.Factory(dataSourceFactory)
                        .createMediaSource(new MediaItem.Builder().setUri(url).build());
            } else {
                sampleSource = new ProgressiveMediaSource.Factory(dataSourceFactory)
                        .createMediaSource(new MediaItem.Builder().setUri(url).build());
            }
            mediaItemsSource.add(sampleSource);
        }
        exoPlayer.setMediaSources(mediaItemsSource);
    }

    private void togglePlay() {
        exoPlayer.setPlayWhenReady(!exoPlayer.getPlayWhenReady());
        changePlayPause(exoPlayer.getPlayWhenReady());
    }

    private void previous() {
        isNewSong = true;
        setBuffer(true);
        if (Callback.playPos > 0) {
            Callback.playPos = Callback.playPos - 1;
        } else {
            Callback.playPos = Callback.arrayList_play.size() - 1;
        }
        if (exoPlayer.getMediaItemCount() != 0) {
            exoPlayer.setPlayWhenReady(true);
        } else {
            startNewSong();
        }
    }

    private void next() {
        isNewSong = true;
        setBuffer(true);
        if (Callback.playPos < (Callback.arrayList_play.size() - 1)) {
            Callback.playPos = Callback.playPos + 1;
        } else {
            Callback.playPos = 0;
        }
        if (exoPlayer.getMediaItemCount() != 0) {
            exoPlayer.setPlayWhenReady(true);
        } else {
            startNewSong();
        }
    }

    private void seekTo(long seek) {
        exoPlayer.seekTo((int) seek);
    }

    private void onCompletion() {
        next();
        startNewSong();
    }

    private void changePlayPause(Boolean flag) {
        try {
            changeEquilizer();
            GlobalBus.getBus().postSticky(new MessageEvent(flag, "playicon"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("StaticFieldLeak")
    private void updateNotiImage() {
        new AsyncTask<String, String, String>() {

            @Override
            protected void onPostExecute(String s) {
                super.onPostExecute(s);
            }

            @Override
            protected String doInBackground(String... strings) {
                try {
                    if(Boolean.TRUE.equals(Callback.isRadio)) {
                        ApplicationUtil.responsePost(Callback.API_URL, helper.getAPIRequest(Callback.METHOD_SINGLE_RADIO,0, Callback.arrayList_play.get(Callback.playPos).getId(),"","","","","","","","", "","", "", null));
                    }
                    getBitmapFromURL(Callback.arrayList_play.get(Callback.playPos).getImage());
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        }.execute();
    }

    private void setBuffer(Boolean isBuffer) {
        if (Boolean.FALSE.equals(isBuffer)) {
            changeEquilizer();
        }
        GlobalBus.getBus().postSticky(new MessageEvent(isBuffer, "buffer"));
    }

    private void changeEquilizer() {
        GlobalBus.getBus().postSticky(new ItemCat("", "", null));
    }

    private void changePlayerPlayPos(int playPos) {
        try {
            Callback.playPos = playPos;
            GlobalBus.getBus().postSticky(Callback.arrayList_play.get(Callback.playPos));
            if (notificationManager != null) {
                updateNotiImage();
            }
            changeEquilizer();
            try {
                if (Boolean.TRUE.equals(Callback.isRadio)) {
                    dbHelper.addToRecent(Callback.arrayList_play.get(Callback.playPos));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getBitmapFromURL(String src) {
        try {
            URL url = new URL(src);
            InputStream input;
            if (src.contains("https://")) {
                HttpsURLConnection connection = (HttpsURLConnection) url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                input = connection.getInputStream();
            } else {
                HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                input = connection.getInputStream();
            }
            bitmap = BitmapFactory.decodeStream(input);
            if (callbackBitmap != null) {
                callbackBitmap.onBitmap(bitmap);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver onCallIncome = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, @NonNull Intent intent) {
            try {
                String a = intent.getStringExtra(TelephonyManager.EXTRA_STATE);
                if (exoPlayer.getPlayWhenReady() && (a.equals(TelephonyManager.EXTRA_STATE_OFFHOOK) || a.equals(TelephonyManager.EXTRA_STATE_RINGING))) {
                        exoPlayer.setPlayWhenReady(false);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    BroadcastReceiver onHeadPhoneDetect = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (exoPlayer.getPlayWhenReady()) {
                    togglePlay();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = focusChange -> {
        switch (focusChange) {
            case AudioManager.AUDIOFOCUS_GAIN:
            case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK:
                break;
            case AudioManager.AUDIOFOCUS_LOSS:
            case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT:
                try {
                    if (exoPlayer.getPlayWhenReady()) {
                        togglePlay();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                break;
        }
    };

    private class NotificationReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, @NonNull Intent intent) {
            switch (Objects.requireNonNull(intent.getAction())) {
                case PlayerNotificationManager.ACTION_PREVIOUS:
                    previous();
                    break;
                case PlayerNotificationManager.ACTION_NEXT:
                    next();
                    break;
                case PlayerNotificationManager.ACTION_STOP:
                    stop(intent);
                    break;
            }
        }
    }

    @NonNull
    private IntentFilter addIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(PlayerNotificationManager.ACTION_PREVIOUS);
        intentFilter.addAction(PlayerNotificationManager.ACTION_NEXT);
        intentFilter.addAction(PlayerNotificationManager.ACTION_NEXT);
        intentFilter.addAction(PlayerNotificationManager.ACTION_STOP);
        return intentFilter;
    }

    private void stop(Intent intent) {
        try {
            Callback.isPlayed = false;

            exoPlayer.setPlayWhenReady(false);
            changePlayPause(false);
            exoPlayer.stop();
            exoPlayer.release();
            exoPlayer = null;
            try {
                mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
                mAudioManager.unregisterMediaButtonEventReceiver(componentName);
                unregisterReceiver(onCallIncome);
                unregisterReceiver(onHeadPhoneDetect);
            } catch (Exception e) {
                e.printStackTrace();
            }
            stopService(intent);
            stopForeground(true);
            stopSelf();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy() {
        try {
            try {
                isRecord();
                Callback.isPlayed = false;
                try {
                    mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
                    mAudioManager.unregisterMediaButtonEventReceiver(componentName);
                    unregisterReceiver(onCallIncome);
                    unregisterReceiver(onHeadPhoneDetect);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                stopForeground(true);
                stopSelf();
            } catch (Exception e) {
                e.printStackTrace();
            }

            unregisterReceiver(notificationReceiver);
            if (mWakeLock.isHeld()) {
                mWakeLock.release();
            }
            dbHelper.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    private void isRecord(){
        if (Boolean.TRUE.equals(AudioRecorder.getIsRecord())){
            AudioRecorder.onStopRecord();
        }
    }
}